/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <X11/Xauth.h>

#include "auth.h"
#include "memory.h"
#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)auth.c	3.4 2/8/99";
#endif


void get_auth_by_addr(struct display_auth *auth_p, struct sockaddr_in *addr_p)
{
	char address_name[4];
	char number_name[20];
	unsigned long in_addr;
	Xauth *auth;

	in_addr = ntohl(addr_p->sin_addr.s_addr);

	address_name[0] = in_addr >> 24;
	address_name[1] = in_addr >> 16;
	address_name[2] = in_addr >> 8;
	address_name[3] = in_addr;

	sprintf(number_name, "%u",
		ntohs(addr_p->sin_port) - WELL_KNOWN_PORT_BASE);

	if ((auth = XauGetAuthByAddr(0, 4, address_name, strlen(number_name),
		number_name, strlen(Auth_Method_Name),
		Auth_Method_Name)) == NULL)
	{
		auth_p->length = 0;
		return;
	}

	auth_p->length = auth->data_length;
	auth_p->cookie = mem_alloc(auth_p->length);
	memcpy(auth_p->cookie, auth->data, auth_p->length);

	XauDisposeAuth(auth);
}
