/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "genargv.h"
#include "memory.h"

#ifndef lint
static char sccsid[] = "@(#)genargv.c	3.4 2/8/99";
#endif


char **gen_argv(char *env_name, char *fallback_str)
{
	char *str, **argv;
	int argc;

	if (env_name == NULL || (str = getenv(env_name)) == NULL)
		str = fallback_str;

	argv = mem_alloc(sizeof *argv);
	argc = 0;

	for (;;)
	{
		char *end_p;
		int len;

		while (*str == ' ')
			str++;

		if (!*str)
			break;

		end_p = strchr(str, ' ');
		if (end_p == 0)
			len = strlen(str);
		else
			len = end_p - str;

		argv[argc] = mem_alloc(len + 1);
		strncpy(argv[argc], str, len);
		argv[argc][len] = 0;

		argc++;
		argv = mem_realloc(argv, (argc + 1) * sizeof *argv);

		str += len;
	}

	argv[argc] = NULL;

	assert(argc > 0);

	return argv;
}


char **copy_argv(char **argv)
{
	int argc, i;
	char **new;

	for (argc = 0; argv[argc] != NULL; argc++);

	new = mem_alloc((argc + 1) * sizeof *new);

	for (i = 0; i < argc; i++)
	{
		new[i] = mem_alloc(strlen(argv[i]) + 1);
		strcpy(new[i], argv[i]);
	}

	new[argc] = NULL;

	return new;
}


void free_argv(char **argv)
{
	char **a;

	for (a = argv; *a; a++)
		mem_free(*a);

	mem_free(argv);
}
