/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#include "popup.h"
#include "strings.h"
#include "priv.h"

#ifndef lint
static char sccsid[] = "@(#)jlock.c	4.1 9/16/00";
#endif


static char password[16] = "";
static struct passwd *pw;

static int xcursor, ycursor;

static char *message_prefix = Lock_Prefix_Msg;

static int fn_len, message_len;


static void init_message(void)
{
	char *user, *p;
	uid_t uid;

	uid = getuid();
	pw = NULL;

	if ((user = getlogin()) != NULL)
	{
		raise_priv();
		pw = getpwnam(user);
		lower_priv();
	}

	if (pw != NULL && pw->pw_uid != uid)
		pw = NULL;

	if (pw == NULL)
	{
		raise_priv();
		pw = getpwuid(uid);
		lower_priv();
	}

	if (pw == NULL || pw->pw_uid != uid)
	{
		fprintf(stderr, Who_Are_You_Err);
		exit(1);
	}

	if ((p = strchr(pw->pw_gecos, ',')) == NULL)
		fn_len = strlen(pw->pw_gecos);
	else
		fn_len = p - pw->pw_gecos;

	message_len = strlen(message_prefix) + strlen(pw->pw_name) +
		fn_len + (fn_len ? 3 : 0);
}


static void create_lock_window(void)
{
	int x, y;

	x = 8;
	y = 2;
	popup_write_string(&x, &y, message_prefix);
	popup_write_string(&x, &y, pw->pw_name);
	if (fn_len)
	{
		int i;

		popup_write_string(&x, &y, " (");
		for (i = 0; i < fn_len; i++)
			popup_write_char(&x, &y, (int)pw->pw_gecos[i]);
		popup_write_char(&x, &y, (int)')');
	}

	x = 8;
	y = 4;
	popup_write_string(&x, &y, Lock_Password_Prompt);

	popup_set_cursor(xcursor = x, ycursor = y);
}


static int lock_input(void)
{
	char str[16];
	int i, n, len;

	if ((n = popup_get_keys(str, sizeof str)) < 1)
		return 1;

	for (i = 0; i < n; i++)
	{
		int do_beep;

		do_beep = 0;

		if (!str[i])
			;
		else if (str[i] == '\r' || str[i] == '\n')
		{
			int ok;

			if (password[0])
				popup_set_cursor(--xcursor, ycursor);

			ok = !strcmp(pw->pw_passwd,
				crypt(password, pw->pw_passwd));
			do_beep = !ok && password[0];
			memset(password, 0, sizeof password);

			if (ok)
				return 0;
		}
		else if ((len = strlen(password)) < sizeof password - 1)
		{
			if (!password[0])
				popup_set_cursor(++xcursor, ycursor);

			password[len] = str[i];
			password[len + 1] = 0;
		}
		else
			do_beep = 1;

		if (do_beep)
			popup_bell();
	}

	return 1;
}


int main(int argc, char **argv)
{
	init_and_lower_priv();
	init_message();
	init_popup(16 + message_len, 7, 5);

	create_lock_window();

	while (lock_input());

	close_popup();

	return 0;
}
