/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>

#include "popup.h"
#include "strings.h"
#include "priv.h"

#ifndef lint
static char sccsid[] = "@(#)jreq.c	4.1 9/16/00";
#endif


static char *message = Exit_Jws_Request_Msg;


static void create_req_window(void)
{
	int x, y;

	x = 8;
	y = 2;
	popup_write_string(&x, &y, message);

	popup_set_cursor(x, y);
}


static int req_input(void)
{
	char answer;
	int n;

	if ((n = popup_get_keys(&answer, sizeof answer)) < 1)
		return 2;

	if (!answer)
		;
	else if (answer == 'y' || answer == 'Y')
		return 1;
	else 
		return 0;
	return 2;
}


int main(int argc, char **argv)
{
	int retval;

	init_and_lower_priv();
	init_popup(16 + strlen(message), 7, 0);

	create_req_window();

	for (;;)
	{
		retval = req_input();
		if (retval < 2)
			break;
	}

	close_popup();

	return retval;
}
