/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "keys.h"
#include "keymap.h"
#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)keys.c	4.1 3/12/99";
#endif


enum { Fallback_None, Fallback_Blank, Fallback_Full };


static struct key keys[N_KEYCODES];

static int fallback_mode;


/*
**	external
*/


void grab_keys(Display *display, Window win)
{
	char *filename, *fallback;
	unsigned i, j;

	if ((filename = getenv(Keymap_Env)) == NULL)
		filename = Keymap_Fallback_Name;

	if ((fallback = getenv(Key_Fallback_Mode_Env)) == NULL)
		fallback_mode = Fallback_None;
	else if (!strncmp(fallback, Key_Fallback_Blank_Mode,
		strlen(Key_Fallback_Blank_Mode)))
		fallback_mode = Fallback_Blank;
	else if (!strncmp(fallback, Key_Fallback_Full_Mode,
		strlen(Key_Fallback_Full_Mode)))
		fallback_mode = Fallback_Full;
	else
		fallback_mode = Fallback_None;

	parse_file(display, filename, keys);

	for (i = 0; i < N_KEYCODES; i++)
		for (j = 0; j < keys[i].n; j++)
			if (keys[i].list[j].grab)
				XGrabKey(display, (KeyCode)i,
					keys[i].list[j].mod_bits, win, False,
					GrabModeAsync, GrabModeAsync);
}


int key_of_event(XKeyEvent *event, char **str, int *n_p)
{
	unsigned mod;
	int mod_i, n;
	struct action *a;

	*str = NULL;
	*n_p = 0;

	if (event->type != KeyPress)
		return Action_None;

	if (event->keycode < 0 || event->keycode >= N_KEYCODES)
		return Action_None;

	mod = event->state;
	a = keys[event->keycode].list;
	for (mod_i = keys[event->keycode].n; mod_i--;)
		if (a[mod_i].mod_bits == (mod & a[mod_i].mod_mask))
			break;

	if (mod_i < 0)
	{
		KeySym xk;
		static char buffer[256]; /* hack! */

		if (fallback_mode == Fallback_None ||
			fallback_mode == Fallback_Blank &&
			keys[event->keycode].in_use)
			return Action_None;

		if ((n = XLookupString(event, buffer,
			sizeof buffer, &xk, NULL)) > 0)
		{
			*str = buffer;
			*n_p = n;
			return Action_Input;
		}

		return Action_None;
	}

	switch (a[mod_i].type)
	{
	case Action_Input:
		*str = a[mod_i].data;
		*n_p = a[mod_i].n;
		return Action_Input;

	case Action_Win_Goto:
	case Action_Win_Move:
		if (a[mod_i].n >= 0 && a[mod_i].n <= N_WINDOWS)
		{
			*n_p = a[mod_i].n;
			return a[mod_i].type;
		}
		else
			return Action_None;

	case Action_Lock:
	case Action_X11:
	case Action_Restart:
	case Action_Exit:
	case Action_Newterm:
	case Action_Compose_Input:
		return a[mod_i].type;

	default:
		return Action_None;
	}
}
