/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>

#include "netcmd.h"
#include "memory.h"

#ifndef lint
static char sccsid[] = "@(#)netcmd.c	4.2 3/4/99";
#endif


struct net_cmdS
{
	net_cmd_typeE type;

	/* optional parameters */
	int x1, y1, x2, y2, x3, y3;
	int v;
};


/* ----- */


net_cmdT make_net_cmd(net_cmd_typeE type, int x1, int y1,
	int x2, int y2, int x3, int y3, int v)
{
	net_cmdT nc;

	nc = mem_alloc(sizeof *nc);

	nc->type = type;
	nc->x1 = x1;
	nc->y1 = y1;
	nc->x2 = x2;
	nc->y2 = y2;
	nc->x3 = x3;
	nc->y3 = y3;
	nc->v = v;

	return nc;
}


void exec_and_release_net_cmd(struct net_state *ns, net_cmdT nc)
{
	switch (nc->type)
	{
	case NC_bell:
		net_bell(ns);
		break;

	case NC_text:
		net_write_char(ns, nc->x1, nc->y1, nc->v);
		net_refresh_cursor(ns);
		break;

	case NC_set_cursor:
		net_set_cursor(ns, nc->x1, nc->y1);
		break;

	case NC_clear:
		net_clear_area(ns, nc->x1, nc->y1, nc->x2, nc->y2);
		net_refresh_cursor(ns);
		break;

	case NC_copy:
		net_hide_cursor(ns);
		net_copy_area(ns, nc->x1, nc->y1, nc->x2, nc->y2,
			nc->x3, nc->y3);
		net_refresh_cursor(ns);
		break;

	case NC_resize:
		net_resize(ns, nc->x1, nc->y1);
		break;

	case NC_lock:
		if (*net_auth_flag(ns))
			net_lock_window(ns);
		break;

	case NC_saver:
		if (*net_auth_flag(ns))
			net_set_saver(ns, nc->v);
		break;

	case NC_auth:
		*net_auth_flag(ns) = nc->v;
		break;

	default:
		abort();
	}

	mem_free(nc);
}
