/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

/* ident "@(#)netcmd.h	4.1 2/13/99" */


typedef enum { NC_bell, NC_text, NC_set_cursor, NC_clear, NC_copy, NC_resize,
	NC_lock, NC_saver, NC_auth } net_cmd_typeE;

typedef struct net_cmdS *net_cmdT;


struct net_state;


extern net_cmdT make_net_cmd(net_cmd_typeE type, int x1, int y1,
	int x2, int y2, int x3, int y3, int v);
extern void exec_and_release_net_cmd(struct net_state *ns, net_cmdT nc);

extern void net_bell(struct net_state *ns);
extern void net_write_char(struct net_state *ns, int x, int y, int ch);
extern void net_set_cursor(struct net_state *ns, int x, int y);
extern void net_clear_area(struct net_state *ns, int x1, int y1,
	int x2, int y2);
extern void net_hide_cursor(struct net_state *ns);
extern void net_copy_area(struct net_state *ns, int x1, int y1,
	int x2, int y2, int xto, int yto);
extern void net_refresh_cursor(struct net_state *ns);
extern void net_resize(struct net_state *ns, int w, int h);
extern void net_lock_window(struct net_state *ns);
extern void net_set_saver(struct net_state *ns, int timeout);
extern int *net_auth_flag(struct net_state *ns);
