/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <unistd.h>
#include <sys/types.h>

#include "priv.h"

#ifndef lint
static char sccsid[] = "@(#)priv.c	4.1 9/16/00";
#endif


static uid_t saved_uid = -1;
static gid_t saved_gid = -1;

static uid_t real_uid = -1;
static gid_t real_gid = -1;


void lower_priv(void)
{
	if (saved_gid != -1)
		setregid(-1, real_gid);
	if (saved_uid != -1)
		setreuid(-1, real_uid);
}


void raise_priv(void)
{
	if (saved_uid != -1)
		setreuid(-1, saved_uid);
	if (saved_gid != -1)
		setregid(-1, saved_gid);
}


void init_and_lower_priv(void)
{
	uid_t euid, ruid;
	gid_t egid, rgid;

	euid = geteuid();
	ruid = getuid();

	egid = getegid();
	rgid = getgid();

	if (euid == ruid)
		saved_uid = real_uid = -1;
	else
	{
		saved_uid = euid;
		real_uid = ruid;
	}

	if (egid == rgid)
		saved_gid = real_gid = -1;
	else
	{
		saved_gid = egid;
		real_gid = rgid;
	}

	lower_priv();
}
