/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

/* ident "@(#)proto.h	4.1 3/3/99" */


enum
{
	Proto_Ev_Key = 'k',
	Proto_Ev_Lock = 'l',
	Proto_Ev_Size = 's',
	Proto_Ev_Nolock = 'L'
};

enum
{
	Proto_Ireq_Authenticate = '#',
	Proto_Dreq_Clear_Area = ' ',
	Proto_Dreq_Copy_Area = '+',
	Proto_Dreq_Bell = 'b',
	Proto_Dreq_Cursor = 'c',
	Proto_Ireq_Term = 'e',
	Proto_Ireq_Lock = 'l',
	Proto_Ireq_Size = 's',
	Proto_Dreq_Text = 't',
	Proto_Ireq_Saver = 'S'
};


extern void append_pair_to_buffer(void **buffer, int *size,
	int lohalf, int hihalf);
extern void append_word_to_buffer(void **buffer, int *size, int word);
extern void get_pair_from_buffer(void **buffer, int *size,
	int *lohalf, int *hihalf, int offset);
extern void append_header_to_buffer(void **buffer, int *size,
	int type, int len);
extern void append_raw_to_buffer(void **buffer, int *size,
	int type, int len, char *raw);
extern int get_type_from_buffer(void **buffer, int *size);
extern int get_len_from_buffer(void **buffer, int *size);
extern int get_word_from_buffer(void **buffer, int *size, int offset);
extern void remove_block_from_buffer(void **buffer, int *size);
extern void remove_block_from_buffer_delay(void **buffer,
	int *size, int *base);
extern void update_input_buffer(void **buffer, int *size, int base);
