/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <ttyent.h>

#include "pty.h"
#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)pty_bsd.c	3.4 2/8/99";
#endif


pid_t forkpty(int *pty_fd, char *tty_name,
	struct termios *term, struct winsize *win)
{
	pid_t pid;
	struct ttyent *tty_ent;
	char name[64];
	int pty, tty, tmp_tty;

	setttyent();
	while ((tty_ent = getttyent()) != NULL)
	{
		if (strlen(tty_ent->ty_name) >= sizeof name - 5 ||
			*tty_ent->ty_name != 't')
			continue;

		strcpy(name, Dev_Prefix);
		strcat(name, tty_ent->ty_name);
		name[5] = 'p';
		if ((pty = open(name, O_RDWR | O_NOCTTY, 0)) < 0)
			continue;

		name[5] = 't';
		if ((tty = open(name, O_RDWR | O_NOCTTY, 0)) < 0)
		{
			close(pty);
			continue;
		}

		break;
	}
	endttyent();

	if (tty_ent == NULL)
		return -1;

	tcsetattr(tty, TCSANOW, term);
	ioctl(tty, TIOCSWINSZ, win);

	*pty_fd = pty;
	if (tty_name != NULL)
		strcpy(tty_name, name);

	if ((pid = fork()) < 0)
	{
		close(tty);
		close(pty);
		return -1;
	}

	if (pid)
	{
		close(tty);
		return pid;
	}

	close(pty);

	if ((tmp_tty = open(Dev_Tty, O_RDWR, 0)) >= 0)
	{
		ioctl(tmp_tty, TIOCNOTTY, NULL);
		close(tmp_tty);
	}

	if ((tmp_tty = open(name, O_RDWR, 0)) < 0)
	{
		fprintf(stderr, Reopen_Tty_Err, name);
		exit(1);
	}
	close(tmp_tty);

	dup2(tty, 0);
	dup2(tty, 1);
	dup2(tty, 2);

	if (tty > 2)
		close(tty);

	return 0;
}
