/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stropts.h>

#include "tty.h"
#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)pty_sv.c	3.4 2/8/99";
#endif


pid_t forkpty(int *pty_fd, char *tty_name,
	struct termios *term, struct winsize *win)
{
	pid_t pid;
	int fds, tty, tmptty;
	char *name;
	extern char *ptsname();

	if (!(*pty_fd = open(Dev_Ptmx, O_RDWR)) || grantpt(*pty_fd) ||
			unlockpt(*pty_fd))
		return -1;

	if ((name = ptsname(*pty_fd)) && (fds = open(name, O_RDWR|O_NOCTTY)))
	{
		ioctl(fds, I_PUSH, Ptem_Module);
		ioctl(fds, I_PUSH, Ldterm_Module);
		if (tty_name)
			strcpy(tty_name, name);
	}
	else
		return -1;
	if (tcsetattr(fds, TCSANOW, term) < 0 ||
		ioctl(fds, TIOCSWINSZ, &win) < 0)
		return -1;
	if ((pid = fork()) < 0)
		return -1;
	if (pid)
	{
		close(fds);
		return pid;
	}
	close(*pty_fd);
	close(fileno(stdin));
	close(fileno(stdout));
	close(fileno(stderr));

	if (fcntl(fds, F_DUPFD, 0) < 0 || fcntl(fds, F_DUPFD, 0) < 0 ||
		fcntl(fds, F_DUPFD, 0) < 0)
	{
		perror(F_DUPFD_Err);
		exit(1);
	}
	setpgrp();

/* HP/UX 10 has no TIOCNOTTY, but it's unnecessary there anyway */
#ifdef TIOCNOTTY
	if ((tty = open(Dev_Tty, O_RDWR)) >= 0)
	{
		ioctl(tty, TIOCNOTTY, (char *) NULL);
		close(tty);
	}
#endif

	if ((tty = open(name, O_RDWR, 0)) >= 0)
	{
		if ((tmptty = open(Dev_Tty, O_RDWR, 0)) >= 0)
			close(tmptty);
		else
		{
			fprintf(stderr, Get_Control_Tty_Err);
			exit(1);
		}
	}
	return 0;
}
