/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <assert.h>

#include "attr.h"
#include "redraw.h"
#include "font.h"
#include "memory.h"

#ifndef lint
static char sccsid[] = "@(#)redraw.c	4.12 2/28/99";
#endif


static void *font_handle;

static int cwidth, cheight;


void init_redraw(void *f_handle, int width, int height)
{
	font_handle = f_handle;

	cwidth = width;
	cheight = height;
}


void redraw_clear_area(int width, int xc, int yc,
	int x1, int y1, int x2, int y2)
{
	if (x2 == width - 1 && xc + width < cwidth)
	{
		int y;

		for (y = y1; y <= y2; y++)
			draw_char(font_handle, xc + x2, yc + y,
				' ' | A_Narrow);
		x2--;
	}

	if (x2 < x1)
		return;

	clear_box(font_handle, x1 + xc, y1 + yc,
		x2 + 1 - x1, y2 + 1 - y1, 0);
}


void redraw_copy_to_screen(unsigned **ws_off_screen,
	int x0, int y0, int width, int height)
{
	int x, y;
	int narrow;

	narrow = x0 + width < cwidth;

	for (y = 0; y < height; y++)
	{
		int k, screen_y;
		unsigned *p;

		p = &ws_off_screen[y][0];
		k = width - narrow;
		x = x0;
		screen_y = y + y0;

		while (k-- > 0)
			draw_char(font_handle, x++, screen_y, *p++);

		if (narrow)
			draw_char(font_handle, x, screen_y, *p | A_Narrow);
	}
}
