/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "screens.h"

#ifndef lint
static char sccsid[] = "@(#)screens.c	4.1 3/4/99";
#endif


/* HACK! - must be at least N like in jws.c */
#define N_SCREENS 100


typedef enum { S_Invisible, S_Visible, S_Focus } modeE;


struct s_win
{
	int name; /* index as passed to s_...() */
	void *data; /* not used yet */
	int page, xc, yc;
	modeE mode;
};

static struct s_win win_states[N_SCREENS];
static int n_used = 0;

static int focus_page = -1;


static int find_win(int name)
{
	int i;

	for (i = 0; i < n_used; i++)
		if (win_states[i].name == name)
			return i;

	return -1;
}


/*
**	external
*/


void s_init_win(int name, int m, int width)
{
	int i;

	i = find_win(name);
	assert(i >= 0);

	win_states[i].page = name / m;
	win_states[i].mode = S_Invisible;
	win_states[i].xc = name % m * width;
	win_states[i].yc = 1;
}


void s_swap(int name1, int name2)
{
	void *tmp;
	modeE m_tmp;
	int i, j;

	i = find_win(name1);
	j = find_win(name2);
	assert(i >= 0);
	assert(j >= 0);

	tmp = win_states[i].data;
	win_states[i].data = win_states[j].data;
	win_states[j].data = tmp;

	/* XXX */
	m_tmp = win_states[i].mode;
	win_states[i].mode = win_states[j].mode;
	win_states[j].mode = m_tmp;
}


void s_set_focus_page(int name, int focus)
{
	int i;

	i = find_win(name);

	if (i >= 0)
		win_states[i].mode = win_states[i].page == focus ?
			S_Visible : S_Invisible;
}


void s_move(int name, int x, int y)
{
	int i;

	i = find_win(name);
	assert(i >= 0);

	win_states[i].xc = x;
	win_states[i].yc = y;
}


void s_move_page(int name, int page)
{
	int i;

	i = find_win(name);
	assert(i >= 0);

	win_states[i].page = page;
}


int s_get_xy_of_visible(int name, int *xc_p, int *yc_p)
{
	int i;

	i = find_win(name);

	if (i < 0 || win_states[i].mode == S_Invisible)
		return 0;

	*xc_p = win_states[i].xc;
	*yc_p = win_states[i].yc;
	return 1;
}


int s_is_visible(int name)
{
	int i;

	i = find_win(name);

	return i >= 0 && win_states[i].mode != S_Invisible;
}


int s_get_page(int name)
{
	int i;

	i = find_win(name);
	assert(i >= 0);

	return win_states[i].page;
}


void s_set_active(int name, int active)
{
	int i;

	i = find_win(name);

	if (active)
	{
		assert(i < 0);
		assert(n_used < sizeof win_states / sizeof *win_states);

		win_states[n_used].name = name;
		n_used++;
	}
	else
	{
		assert(i >= 0);

		memcpy(&win_states[i], &win_states[n_used - 1],
			sizeof *win_states);
		n_used--;
	}
}


int s_get_active(int name)
{
	int i;

	i = find_win(name);

	return i >= 0;
}
