/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)strings.c	4.5 11/12/00";
#endif


/*BODY*/


/* environment */
char Server_Default_Env[] =	"JSERVER";
char Server_Fallback_Env[] =	"DISPLAY";
char Keymap_Env[] =		"JWS_KEYMAP";
char Key_Fallback_Mode_Env[] =	"JWS_KEY_FALLBACK";
char Font_File_Env[] =		"JFONT";
char Font_Conf_File_Env[] =	"JFONT_CF";
char Shell_Env[] =		"SHELL";
char Lock_Tool_Env[] =		"JWS_LOCK";
char Term_Tool_Env[] =		"JWS_TERM";
char Req_Tool_Env[] =		"JWS_REQ";

/* executables */
char Lock_Tool_Default[] =	"jlock";
char Term_Tool_Default[] =	"jterm";
char Req_Tool_Default[] =	"jreq";
char Default_Shell[] =		"/bin/csh";

/* command line arguments */
char As_Login_Shell_Opt[] =	"-ls";

/* files */
char Keymap_Fallback_Name[] =	"keymap";
char Font_File_Fallback_Name[] =	"font";
char Font_Conf_File_Fallback_Name[] =	"font.cf";

/* general output */
char Exit_Jws_Request_Msg[] =	"Exit jws (y/n)?";
char Lock_Prefix_Msg[] =	"Screen locked by ";
char Lock_Password_Prompt[] =	"Password:";
char Term_Esc_Str[] =		"<ESC>";
char Term_Char_Str[] =		"<%c>";
char Term_Octal_Str[] =		"<\\0%o>";

/* warning messages */
char Fork_Warn[] =		"warning: fork failed\n";
char Keymap_Read_Warn[] =	"warning: can't read keymap file \"%1$s\"\n";
char Keymap_Parse_Warn[] =	"warning: parse error in line %1$d\n";
char Keymap_Keycode_Warn[] =	"warning: invalid key code in line %1$d\n";
char Keymap_Redef_Warn[] =	"warning: key redefinition in line %1$d\n";

/* error messages */
char Bind_Socket_Err[] =	"can't bind display socket\n";
char Connect_Err[] =		"can't connect to server\n";
char Exec_Err[] =		"can't execute %1$s\n";
char Fork_Shell_Err[] =		"can't fork shell\n";
char F_DUPFD_Err[] =		"F_DUPFD failed";
char Get_Control_Tty_Err[] =	"could not get controlling terminal\n";
char Init_Term_Emul_Err[] =	"can't initialize terminal emulator\n";
char Lock_Rejected_Err[] =	"lock request rejected\n";
char Open_Display_Err[] =	"can't open display\n";
char Out_Of_Memory_Err[] =	"out of memory\n";
char Read_From_Server_Err[] =	"read from server failed\n";
char Reopen_Tty_Err[] =		"can't reopen tty %1$s\n";
char Reset_Sig_Handlers_Err[] =	"can't reset signal handlers\n";
char Restart_Err[] =		"can't restart jws";
char Screen_Depth_Err[] =	"DefaultDepth < 8\n";
char Select_Err[] =		"select failed\n";
char SIGCHLD_Handler_Err[] =	"can't install SIGCHLD handler\n";
char Term_Seq_Rejected_Err[] =	"sequence rejected: ";
char Term_Seq_Too_Long_Err[] =	"sequence too long, processing ceased\n";
char Who_Are_You_Err[] =	"Who are you?\n";
char Write_To_Server_Err[] =	"write to server failed\n";
char Write_Utmpx_Err[] =	"could not write utmpx entry\n";

/* misc. */
char Jws_Version[] =		"jws 1.6";
char Auth_Method_Name[] =	"JWS-MAGIC-COOKIE-1";
char Open_Display_Arg[] =	"";
char Server_Fallback_IP[] =	"127.0.0.1";
char Wwm_Sticky_Prop[] =	"_WWM_IS_STICKY";
char Activity_Indicator[] =	":#=-+";
char Focus_Indicator[] =	" < < <";
char Dev_Prefix[] =		"/dev/";
char Dev_Tty[] =		"/dev/tty";
char Dev_Ptmx[] =		"/dev/ptmx";
char Set_Term_Env[] =		"TERM=xterm";
char Fallback_Utmpx_User[] =	"????";
char Ptem_Module[] =		"ptem";
char Ldterm_Module[] =		"ldterm";
char Key_Fallback_Blank_Mode[] =	"b";
char Key_Fallback_Full_Mode[] =	"f";
