/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

/* ident "@(#)term_actions.h	3.4 2/8/99" */


enum { Sequence_OK, Sequence_Incomplete, Sequence_Invalid };

enum { Dont_Scroll, Do_Scroll };

#define BOTTOM_LINE	(-1)


extern int exec_sequence(void *h, char *seq);

extern void term_cursor_abs_vert(void *handle, int y);
extern void term_cursor_rel_vert(void *handle, int dy, int scroll);
extern void term_cursor_abs_horiz(void *handle, int x);
extern void term_clear_to_eol(void *handle);
extern void term_cursor_rel_horiz(void *handle, int dx);
extern void term_cursor_tab(void *handle);
extern void term_insert_char(void *handle);
extern void term_delete_char(void *handle);
extern void term_insert_line(void *handle);
extern void term_delete_line(void *handle);
extern void term_clear_to_eod(void *handle);
extern void term_save_cursor(void *handle);
extern void term_restore_cursor(void *handle);
extern int term_get_mode(void *handle);
extern void term_set_mode(void *handle, int mode);
extern void term_scroll_region(void *handle, int top, int bottom);
extern void term_bell(void *handle);
