/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <utmpx.h>

#include "utmp.h"
#include "strings.h"

#ifndef lint
static char sccsid[] = "@(#)utmp_sol.c	3.4 2/8/99";
#endif


static char *utmpx_ptsid(char *line)
{
	static char buf[4];
	char *lp;

	buf[0] = buf[1] = ' ';
	buf[4] = '\0';

	lp = strrchr(line, '/');
	if (strlen(lp) == 1)
	{
		buf[3] = *lp;
		buf[2] = '/';
	}
	else
		strncpy(buf + 2, lp, 2);
		
	return(buf);
}


void utmp_login(char *line, char *user, char *host)
{
	struct utmpx ut, *utp;
	pid_t mypid;
	
	mypid = getpid();

	memset((void *)&ut, 0, sizeof ut);
	setutxent();

	while (utp = getutxent())
	{
		if (utp->ut_type == DEAD_PROCESS &&
			(strcmp(utp->ut_line, line + 5) == 0))
			break;
	}

	strncpy(ut.ut_line, line + 5, sizeof ut.ut_line);
	strncpy(ut.ut_id, utmpx_ptsid(line), sizeof ut.ut_id);
	strncpy(ut.ut_user, user, sizeof ut.ut_user);

	if (host != NULL)
	{
		strncpy(ut.ut_host, host, sizeof ut.ut_host);
		ut.ut_syslen = strlen(host) + 1;
	}
	else
		ut.ut_syslen = 0;

	if (ut.ut_syslen > sizeof ut.ut_host)
		ut.ut_syslen = sizeof ut.ut_host;

	ut.ut_type = USER_PROCESS;
	gettimeofday(&ut.ut_tv, (void *)NULL);
	ut.ut_pid = mypid;

	if (pututxline(&ut) == NULL)
		fprintf(stderr, Write_Utmpx_Err);

	endutxent();
}
