%{

/*
**	Copyright (c) 1995-2000 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions
**	are met:
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

/*
**	included:
**
**	Dec OSF/1 2.0	termcap, terminfo source
**	SunOS 4.1.3	termcap, terminfo dump
**
**	excluded:
**
**	status line, "sgr", keypad transmit mode, alternate charset
*/

#include "attr.h"
#include "term_actions.h"

#ifndef lint
static char sccsid[] = "@(#)xterm.y	3.5 2/8/99";
#endif


#define REPEAT(n) int i; for (i = (n); i-- > 0;)


static void *handle;
static char *sequence;
static int state;


/* missing in yaccpar */
int yyparse(void);


int exec_sequence(void *h, char *seq)
{
	handle = h;
	sequence = seq;

	state = Sequence_OK;
	if (!yyparse())
		state = Sequence_OK;

	return state;
}


static void yyerror(char *msg)
{
	if (state == Sequence_OK)
		state = Sequence_Invalid;
}


static int yylex(void)
{
	if (!*sequence)
	{
		if (state == Sequence_OK)
			state = Sequence_Incomplete;
		return -1;
	}
	return *sequence++;
}

%}

%start	ctrl_sequence

%%

digit	: '0' {$$=0;}	| '1' {$$=1;}	| '2' {$$=2;}	| '3' {$$=3;}
	| '4' {$$=4;}	| '5' {$$=5;}	| '6' {$$=6;}	| '7' {$$=7;}
	| '8' {$$=8;}	| '9' {$$=9;}
	;

number0	:	{ $$ = 0; }
	|	number0 digit	{ $$ = $1 * 10 + $2; }
	;

number1	:	{ $$ = 1; }
	|	number0 digit	{ $$ = $1 * 10 + $2; }
	;

skip_number
	:	number1
	;

skip_list
	:	skip_number
	|	skip_number ';' skip_list
	;

ctrl_sequence
	:	'\033' esc_sequence
	|	'\007'	{ term_bell(handle); }
	|	'\016'	{ /* into "alternate charset" */ }
	|	'\017'	{ /* out of "alternate charset" */ }
	|	'\b'	{ term_cursor_rel_horiz(handle, -1); }
	|	'\n'	{ term_cursor_rel_vert(handle, 1, Do_Scroll); }
	|	'\r'	{ term_cursor_abs_horiz(handle, 1); }
	|	'\t'	{ term_cursor_tab(handle); }
	;

esc_sequence
	:	'\033' esc_sequence
	|	'[' csi_sequence
	|	'(' 'B'	{ /* enable alternate charset, 1st half */ }
	|	')' '0'	{ /* enable alternate charset, 2nd half */ }
	|	'7'	{ term_save_cursor(handle); }
	|	'8'	{ term_restore_cursor(handle); }
	|	'<'	{ /* reset string */ }
	|	'='	{ /* into "keypad transmit", 2nd half */ }
	|	'>'	{ /* out of "keypad transmit", 2nd half */ }
	|	'M'	{ term_cursor_rel_vert(handle, -1, Do_Scroll); }
	;

csi_sequence
	:	number1 '@'	{ REPEAT($1) term_insert_char(handle); }
	|	number1 'A'
			{ REPEAT($1) term_cursor_rel_vert(handle,
				-1, Dont_Scroll); }
	|	number1 'B'
			{
				REPEAT($1)
					term_cursor_rel_vert(handle, 1,
						Dont_Scroll);
			}
	|	number1 'C'
			{ REPEAT($1) term_cursor_rel_horiz(handle, 1); }
	|	number1 'D'
			{ REPEAT($1) term_cursor_rel_horiz(handle, -1); }
	|	skip_number 'g'	{ /* 3: clears tabs */ }
	|	number1 'H'
			{
				term_cursor_abs_vert(handle, $1);
				term_cursor_abs_horiz(handle, 1);
			}
	|	number1 ';' number1 'H'
			{
				term_cursor_abs_vert(handle, $1);
				term_cursor_abs_horiz(handle, $3);
			}
	|	skip_number 'J'	{ term_clear_to_eod(handle); }
	|	'K'	{ term_clear_to_eol(handle); }
	|	number1 'L'	{ REPEAT($1) term_insert_line(handle); }
	|	number1 'M'	{ REPEAT($1) term_delete_line(handle); }
	|	number0 'm'
			{
				int mode;

				mode = term_get_mode(handle);
				switch ($1)
				{
					case 0: mode = 0; break;
					case 1: mode |= BOLD; break;
					case 4: mode |= UNDERLINE; break;
					/* 5: blink */
					case 7: mode |= REVERSE; break;
				}
				term_set_mode(handle, mode);
			}
	|	number1 'P'	{ REPEAT($1) term_delete_char(handle); }
	|	number1 'r'	{ term_scroll_region(handle, $1, BOTTOM_LINE); }
	|	number1 ';' number1 'r'	{ term_scroll_region(handle, $1, $3); }
	|	'?' number1 'T'	{ /* goto status line */ }
	|	'?' 'E'	{ /* disable status line */ }
	|	'?' 'F'	{ /* return from status line */ }
	|	'?' skip_number 'h'
			{
				/* 1: into "keypad transmit" */
				/* 47: termcap init/end */
				/* 7: init string */
			}
	|	'?' skip_list 'l'
			{
				/* 1: out of "keypad transmit" */
				/* 1;4: init string */
				/* 1;3;4;6: reset string */
				/* 1;3;4;5;6: reset string */
				/* 47: "rmcup" */
			}
	;
