/*
**	Joerg.Czeranski@Informatik.TU-Clausthal.DE
*/

#include <stdio.h>

#include "rules.h"

static char sccsid[] = "@(#)octopawn.c	1.18 7/25/96";


static struct { int code; char *text; } messages[] =
{
	{ MOVE_INVALID_SRC, "invalid source of move" },
	{ MOVE_INVALID_DEST, "invalid destination of move" },
	{ MOVE_NOP, "source and destination of move are identical" },
	{ MOVE_TOO_FAR, "source and destination of move aren't adjacent" },
	{ MOVE_NO_SRC_STONE, "source of move is empty" },
	{ MOVE_OPP_SRC_STONE, "source of move is an opponent's stone" },
	{ MOVE_ALREADY_TWO, "already two of your stones at the destination" },
	{ MOVE_CAPTURE_TWO, "can't capture two stones at once" },
	{ MOVE_REVERSES_1ST, "second move can't reverse first move" }
};

static char usage[] = "input format: x1y1x2y2 (e.g. a4b5)\n";


static int get_char(str_p, min, max)
char **str_p;
int min, max;
{
	while (**str_p == ' ')
		(*str_p)++;

	if (**str_p < min || **str_p > max)
		return -1;

	return *(*str_p)++ - min;
}


static void read_move(to_play, m_p)
int to_play;
struct move *m_p;
{
	char move_str[1024], *p;

	for (;;)
	{
		printf("%s, your move? ", to_play > 0 ? "#" : "O");
		if (gets(move_str) == NULL)
		{
			printf("\n");
			exit(0);
		}

		p = move_str;
		if ((m_p->from.x = get_char(&p, 'a', 'g')) < 0 ||
			(m_p->from.y = get_char(&p, '1', '7')) < 0 ||
			(m_p->to.x = get_char(&p, 'a', 'g')) < 0 ||
			(m_p->to.y = get_char(&p, '1', '7')) < 0)
		{
			printf(usage);
			continue;
		}

		while (*p == ' ')
			p++;

		if (*p)
		{
			printf(usage);
			continue;
		}

		break;
	}

	m_p->from.x -= 3;
	m_p->from.y = 3 - m_p->from.y;
	m_p->to.x -= 3;
	m_p->to.y = 3 - m_p->to.y;
}


static void draw_sep_line(len)
int len;
{
	int x;

	for (x = 3 - len; x-- > 0;)
		printf("    ");

	printf("+");
	for (x = -len; x <= len; x++)
		printf("---+");

	printf("\n");
}


static void draw_board_line(s_p, len, y, finished_flag)
struct state *s_p;
int len, y, finished_flag;
{
	int x;

	for (x = 3 - len; x-- > 0;)
		if (x == 1 && finished_flag)
			if (y < 0)
				printf(" #  ");
			else
				printf(" O  ");
		else
			printf("    ");

	printf("|");
	for (x = -len; x <= len; x++)
	{
		switch (board_state(s_p, x, y))
		{
		case -2:
			printf("O O");
			break;

		case -1:
			printf(" O ");
			break;

		case 0:
			printf("   ");
			break;

		case 1:
			printf(" # ");
			break;

		case 2:
			printf("# #");
			break;
		}

		printf("|");
	}

	for (x = 3 - len; x-- > 0;)
		printf("    ");
}


static void draw_board(s_p)
struct state *s_p;
{
	int y;

	printf("\n     a   b   c   d   e   f   g\n");

	for (y = -3; y <= 0; y++)
	{
		printf("   ");
		draw_sep_line(y + 3);

		printf(" %d ", 4 - y);
		draw_board_line(s_p, y + 3, y,
			y == -3 && s_p->black.stones_finished);
		printf(" %d\n", 4 - y);
	}

	printf("   ");
	draw_sep_line(3, 0);

	for (; y <= 3; y++)
	{
		printf(" %d ", 4 - y);
		draw_board_line(s_p, 3 - y, y,
			y == 3 && s_p->white.stones_finished);
		printf(" %d\n", 4 - y);

		printf("   ");
		draw_sep_line(3 - y);
	}

	printf("     a   b   c   d   e   f   g\n\n");
}


static void read_valid_move(s_p, m_p)
struct state *s_p;
struct move *m_p;
{
	int move_stat, i;

	for (;;)
	{
		read_move(s_p->to_play, m_p);
		move_stat = check_move(s_p, m_p);

		if (move_stat == MOVE_OK)
			break;

		for (i = sizeof messages / sizeof *messages;
			i-- > 0 && messages[i].code != move_stat;);

		printf("%s\n", i < 0 ? "invalid move" : messages[i].text);
	}
}


int main()
{
	struct state state, *s_p;
	struct move m;

	s_p = &state;

	init_game(s_p);

	draw_board(s_p);

	read_valid_move(s_p, &m);
	move(s_p, &m);

	while (!s_p->winner)
	{
		draw_board(s_p);

		read_valid_move(s_p, &m);
		move(s_p, &m);
	}

	draw_board(s_p);
	printf("%s has won\n\n", s_p->winner > 0 ? "#" : "O");

	return 0;
}
