/*
**	Joerg.Czeranski@Informatik.TU-Clausthal.DE
*/

#include <stdio.h>

#include "rules.h"

static char sccsid[] = "@(#)rules.c	1.6 7/25/96";


/*
**	local
*/


static int board_state_player(p_p, x, y)
struct player *p_p;
int x, y;
{
	int i, s;

	s = 0;
	for (i = 0; i < p_p->n_stones; i++)
		if (p_p->stones[i].x == x && p_p->stones[i].y == y)
			s++;

	return s;
}


static void init_player(p_p, sign)
struct player *p_p;
int sign;
{
	p_p->stones_finished = 0;
	p_p->n_stones = 4;

	p_p->stones[0].x = 0;
	p_p->stones[0].y = 3 * sign;

	p_p->stones[1].x = -1;
	p_p->stones[1].y = 2 * sign;

	p_p->stones[2].x = 0;
	p_p->stones[2].y = 2 * sign;

	p_p->stones[3].x = 1;
	p_p->stones[3].y = 2 * sign;
}


/*
**	global
*/


int board_state(s_p, x, y)
struct state *s_p;
int x, y;
{
	return board_state_player(&s_p->black, x, y) -
		board_state_player(&s_p->white, x, y);
}


int check_move(s_p, m_p)
struct state *s_p;
struct move *m_p;
{
	int from_s, to_s;

	if (m_p->from.x < -3 - m_p->from.y || m_p->from.x < -3 + m_p->from.y ||
		m_p->from.x > 3 + m_p->from.y || m_p->from.x > 3 - m_p->from.y)
		return MOVE_INVALID_SRC;

	if (m_p->to.x < -3 - m_p->to.y || m_p->to.x < -3 + m_p->to.y ||
		m_p->to.x > 3 + m_p->to.y || m_p->to.x > 3 - m_p->to.y)
		return MOVE_INVALID_DEST;

	if (m_p->from.x == m_p->to.x && m_p->from.y == m_p->to.y)
		return MOVE_NOP;

	if (m_p->from.x - m_p->to.x > 1 ||
		m_p->from.x - m_p->to.x < -1 ||
		m_p->from.y - m_p->to.y > 1 ||
		m_p->from.y - m_p->to.y < -1)
		return MOVE_TOO_FAR;

	from_s = board_state(s_p, m_p->from.x, m_p->from.y) * s_p->to_play;
	if (!from_s)
		return MOVE_NO_SRC_STONE;

	if (from_s < 0)
		return MOVE_OPP_SRC_STONE;

	to_s = board_state(s_p, m_p->to.x, m_p->to.y) * s_p->to_play;
	if (to_s == 2)
		return MOVE_ALREADY_TWO;

	if (to_s == -2)
		return MOVE_CAPTURE_TWO;

	if (s_p->move_no == 2)
	{
		if ((m_p->to.y == 3 * s_p->to_play ||
			m_p->to.y == 2 * s_p->to_play) && to_s == 0 &&
			((m_p->from.y == 3 * s_p->to_play ||
			m_p->from.y == 2 * s_p->to_play) && from_s == 2 ||
			m_p->from.y == 1 * s_p->to_play && from_s == 1))
			return MOVE_REVERSES_1ST;
	}

	return MOVE_OK;
}


void move(s_p, m_p)
struct state *s_p;
struct move *m_p;
{
	struct player *p_p, *e_p;
	int i, j, keep_stone;

	p_p = s_p->to_play > 0 ? &s_p->black : &s_p->white;
	e_p = s_p->to_play > 0 ? &s_p->white : &s_p->black;

	keep_stone = 0;

	for (i = 0; p_p->stones[i].x != m_p->from.x ||
		p_p->stones[i].y != m_p->from.y; i++);

	p_p->stones[i].x = m_p->to.x;
	p_p->stones[i].y = m_p->to.y;

	for (j = 0; j < e_p->n_stones && (e_p->stones[j].x != m_p->to.x ||
		e_p->stones[j].y != m_p->to.y); j++);
	if (j < e_p->n_stones)
	{
		int m;

		m = e_p->n_stones - 1;
		e_p->stones[j].x = e_p->stones[m].x;
		e_p->stones[j].y = e_p->stones[m].y;

		e_p->n_stones--;

		if (!e_p->n_stones)
		{
			s_p->winner = e_p->stones_finished ?
				-s_p->to_play : s_p->to_play;
			if (e_p->stones_finished)
				keep_stone = 1;
		}
	}

	if (!keep_stone && m_p->to.y == -3 * s_p->to_play)
	{
		int m;

		m = p_p->n_stones - 1;
		p_p->stones[i].x = p_p->stones[m].x;
		p_p->stones[i].y = p_p->stones[m].y;

		p_p->n_stones--;
		p_p->stones_finished++;

		if (!p_p->n_stones)
			s_p->winner = s_p->to_play;
	}

	if (!s_p->winner)
	{
		if (s_p->move_no > 1)
			s_p->to_play = -s_p->to_play;
		s_p->move_no++;
	}
}


void init_game(s_p)
struct state *s_p;
{
	init_player(&s_p->black, 1);
	init_player(&s_p->white, -1);
	s_p->winner = 0;
	s_p->to_play = 1;
	s_p->move_no = 1;
}
