/*
**	Joerg.Czeranski@Informatik.TU-Clausthal.DE
*/

#include <stdio.h>
#include <X11/X.h>
#include <X11/Xlib.h>

#include "rules.h"

static char sccsid[] = "@(#)xoctopawn.c	1.30 7/25/96";


#define D_TILE 60 /*100*/

#define PERSP_VAL (D_TILE / 10)
#define PERSP_SIGN (-1)

#define D_STONE (D_TILE * 7 / 10)
#define D2_STONE (D_TILE * 5 / 10)
#define D3_STONE (D_TILE * 4 / 10)

#define BORDER (D_TILE * 5 / 10)

#define PERSP_X (PERSP_SIGN * PERSP_VAL)
#define PERSP_Y PERSP_VAL
#define R_TILE (D_TILE / 2)
#define R_STONE (D_STONE / 2)
#define R_STONE_SQRT2 (D_STONE * 408 / 557 / 2)
#define R2_STONE (D2_STONE / 2)
#define R3_STONE (D3_STONE / 2)
#define WIN_SIZE (7 * D_TILE + 2 * BORDER)


static struct colors
{
	GC board_edge, board_top, board_front, board_side;
	struct flat_colors
	{
		GC edge, face;
	} pointer;
	struct player_colors
	{
		struct flat_colors top;
		GC side, cross;
	} player1, player2;
} colors;

static Display *display;
static int screen;


/*
**	graphics
*/


static void draw_tile(win, colors_p, x0, y0)
Window win;
struct colors *colors_p;
int x0, y0;
{
	int x, y;
	XPoint p[7];

	x = (x0 + 3) * D_TILE + R_TILE + BORDER;
	y = (y0 + 3) * D_TILE + R_TILE + BORDER;

	p[0].x = x + PERSP_SIGN * R_TILE;
	p[0].y = y + R_TILE;

	p[1].x = x - PERSP_SIGN * R_TILE;
	p[1].y = y + R_TILE;

	p[2].x = x - PERSP_SIGN * R_TILE + PERSP_X;
	p[2].y = y + R_TILE + PERSP_Y;

	p[3].x = x + PERSP_SIGN * R_TILE + PERSP_X;
	p[3].y = y + R_TILE + PERSP_Y;

	p[4].x = x + PERSP_SIGN * R_TILE + PERSP_X;
	p[4].y = y - R_TILE + PERSP_Y;

	p[5].x = x + PERSP_SIGN * R_TILE;
	p[5].y = y - R_TILE;

	p[6].x = x + PERSP_SIGN * R_TILE;
	p[6].y = y + R_TILE;

	XFillRectangle(display, win, colors_p->board_top,
		x - R_TILE, y - R_TILE, D_TILE, D_TILE);
	XFillPolygon(display, win, colors_p->board_front, p, 4,
		Convex, CoordModeOrigin);
	XFillPolygon(display, win, colors_p->board_side, p + 3, 4,
		Convex, CoordModeOrigin);

	XDrawRectangle(display, win, colors_p->board_edge,
		x - R_TILE, y - R_TILE, D_TILE, D_TILE);
	XDrawLines(display, win, colors_p->board_edge, p + 1, 5,
		CoordModeOrigin);
	XDrawLine(display, win, colors_p->board_edge,
		x + PERSP_SIGN * R_TILE, y + R_TILE,
		x + PERSP_SIGN * R_TILE + PERSP_X, y + R_TILE + PERSP_Y);
}


static void draw_stone(win, colors_p, x0, y0, z0)
Window win;
struct player_colors *colors_p;
int x0, y0, z0;
{
	int x, y;
	XPoint p[4];

	x = (x0 + 3) * D_TILE + R_TILE + BORDER - z0 * PERSP_X;
	y = (y0 + 3) * D_TILE + R_TILE + BORDER - z0 * PERSP_Y;

	p[0].x = x + PERSP_SIGN * R_STONE_SQRT2;
	p[0].y = y - R_STONE_SQRT2;

	p[1].x = x + PERSP_SIGN * R_STONE_SQRT2 - PERSP_X;
	p[1].y = y - R_STONE_SQRT2 - PERSP_Y;

	p[2].x = x - PERSP_SIGN * R_STONE_SQRT2 - PERSP_X;
	p[2].y = y + R_STONE_SQRT2 - PERSP_Y;

	p[3].x = x - PERSP_SIGN * R_STONE_SQRT2;
	p[3].y = y + R_STONE_SQRT2;

	XFillArc(display, win, colors_p->side, x - R_STONE, y - R_STONE,
		D_STONE, D_STONE, 0, 360 * 64);
	XFillPolygon(display, win, colors_p->side, p, 4,
		Convex, CoordModeOrigin);
	XFillArc(display, win, colors_p->top.face, x - R_STONE - PERSP_X,
		y - R_STONE - PERSP_Y, D_STONE, D_STONE, 0, 360 * 64);

	XDrawArc(display, win, colors_p->top.edge, x - R_STONE, y - R_STONE,
		D_STONE, D_STONE, 180 * 64 + PERSP_SIGN * 45 * 64, 180 * 64);
	XDrawArc(display, win, colors_p->top.edge, x - R_STONE - PERSP_X,
		y - R_STONE - PERSP_Y, D_STONE, D_STONE,
		0, 360 * 64);

	XDrawLine(display, win, colors_p->top.edge,
		x + PERSP_SIGN * R_STONE_SQRT2 - PERSP_X,
		y - R_STONE_SQRT2 - PERSP_Y,
		x + PERSP_SIGN * R_STONE_SQRT2, y - R_STONE_SQRT2);
	XDrawLine(display, win, colors_p->top.edge,
		x - PERSP_SIGN * R_STONE_SQRT2 - PERSP_X,
		y + R_STONE_SQRT2 - PERSP_Y,
		x - PERSP_SIGN * R_STONE_SQRT2, y + R_STONE_SQRT2);

	XDrawArc(display, win, colors_p->top.edge, x - R2_STONE - PERSP_X,
		y - R2_STONE - PERSP_Y, D2_STONE, D2_STONE, 0, 360 * 64);
	XDrawArc(display, win, colors_p->top.edge, x - R3_STONE - PERSP_X,
		y - R3_STONE - PERSP_Y, D3_STONE, D3_STONE, 0, 360 * 64);
}


static void draw_cross(win, colors_p, x0, y0, z0)
Window win;
struct player_colors *colors_p;
int x0, y0, z0;
{
	int x, y;
	int angle;

	x = (x0 + 3) * D_TILE + R_TILE + BORDER - (z0 + 1) * PERSP_X;
	y = (y0 + 3) * D_TILE + R_TILE + BORDER - (z0 + 1) * PERSP_Y;

	for (angle = (90 - 20) * 64; angle < 360 * 64; angle += 90 * 64)
		XFillArc(display, win, colors_p->cross,
			x - R3_STONE, y - R3_STONE,
			D3_STONE, D3_STONE, angle, 40 * 64);
}


static void draw_pointer(win, colors_p, x0, y0, z0, dir)
Window win;
struct flat_colors *colors_p;
int x0, y0, z0, dir;
{
	int x, y;
	int i, xx, xy, yx, yy;
	XPoint p[16];
	static int dx[16] = { -30, 10, 10, 30, 10, 10, -30, -30,
		-25, -25, 15, 15, 23, 15, 15, -25 };
	static int dy[16] = { -10, -10, -20, 0, 20, 10, 10, -10,
		-5, 5, 5, 8, 0, -8, -5, -5 };
	static int xx_dirs[8] = { 557, 408, 0, -408, -557, -408, 0, 408 };
	static int xy_dirs[8] = { 0, 408, 557, 408, 0, -408, -557, -408 };
	static int yx_dirs[8] = { 0, -408, -557, -408, 0, 408, 557, 408 };
	static int yy_dirs[8] = { 557, 408, 0, -408, -557, -408, 0, 408 };

	x = (x0 + 3) * D_TILE + R_TILE + BORDER - (2 * z0 + 3) * PERSP_X / 2;
	y = (y0 + 3) * D_TILE + R_TILE + BORDER - (2 * z0 + 3) * PERSP_Y / 2;

	xx = xx_dirs[dir];
	xy = xy_dirs[dir];
	yx = yx_dirs[dir];
	yy = yy_dirs[dir];

	x += xx / 408 * R_TILE;
	y += yx / 408 * R_TILE;

	for (i = 0; i < 16; i++)
	{
		p[i].x = x + xx * dx[i] * D_TILE / 100 / 557 +
			xy * dy[i] * D_TILE / 100 / 557;
		p[i].y = y + yx * dx[i] * D_TILE / 100 / 557 +
			yy * dy[i] * D_TILE / 100 / 557;
	}

	XFillPolygon(display, win, colors_p->face, p, 16,
		Nonconvex, CoordModeOrigin);

	XDrawLines(display, win, colors_p->edge, p, 8, CoordModeOrigin);
	XDrawLines(display, win, colors_p->edge, p + 8, 8, CoordModeOrigin);
}


static void draw_board(win, colors_p)
Window win;
struct colors *colors_p;
{
	int x, y, y_abs;

	for (y = -3; y <= 3; y++)
	{
		y_abs = y < 0 ? -y : y;

		for (x = y_abs - 3; x <= 3 - y_abs; x++)
			draw_tile(win, colors_p, PERSP_SIGN * x, y);
	}
}


static void draw_stack(win, colors_p, x, y, val)
Window win;
struct colors *colors_p;
int x, y, val;
{
	int i;
	struct player_colors *c_p;

	if (val < 0)
	{
		c_p = &colors_p->player2;
		val = -val;
	}
	else
		c_p = &colors_p->player1;

	for (i = 0; i < val; i++)
		draw_stone(win, c_p, x, y, i);
}


static void draw_game(win, colors_p, s_p, move_data, move_state)
Window win;
struct colors *colors_p;
struct state *s_p;
struct move *move_data;
int move_state;
{
	int x, y, y_abs;

	if (s_p->winner)
	{
		draw_stack(win, &colors, 5, 0, s_p->winner);
		draw_cross(win,
			s_p->winner > 0 ? &colors.player1 : &colors.player2,
			5, 0, 0);
	}
	else if (s_p->to_play > 0)
		draw_pointer(win, &colors.player1.top, 5, 0, -1, 2);
	else
		draw_pointer(win, &colors.player2.top, 5, 0, -1, 6);

	draw_board(win, colors_p);

	for (y = -3; y <= 3; y++)
	{
		y_abs = y < 0 ? -y : y;

		for (x = -3; x <= 3; x++)
			draw_stack(win, &colors, x, y, board_state(s_p, x, y));
	}

	if (move_state >= 1)
	{
		int val;
		struct player_colors *colors_p;

		x = move_data->from.x;
		y = move_data->from.y;

		val = board_state(s_p, x, y);
		if (val < 0)
		{
			colors_p = &colors.player2;
			val = -val;
		}
		else
			colors_p = &colors.player1;

		draw_cross(win, colors_p, x, y, val - 1);

		if (move_state >= 2)
		{
			int dx, dy;
			static int dir[3][3] =
			{
				{ 3, 2, 1 },
				{ 4, 9, 0 },
				{ 5, 6, 7 }
			};

			dx = move_data->to.x - move_data->from.x;
			dy = move_data->to.y - move_data->from.y;

			draw_pointer(win, &colors.pointer, x, y, val - 1,
				dir[dy + 1][dx + 1]);
		}
	}

	draw_stack(win, &colors, 3, 3, s_p->black.stones_finished);
	draw_stack(win, &colors, 3, -3, -s_p->white.stones_finished);

	draw_stack(win, &colors, 4, -3,
		4 - s_p->black.n_stones - s_p->black.stones_finished);
	draw_stack(win, &colors, 4, 3,
		-(4 - s_p->white.n_stones - s_p->white.stones_finished));
}


static int process_click(win, colors_p, s_p, move_data, move_state_p, x, y)
Window win;
struct colors *colors_p;
struct state *s_p;
struct move *move_data;
int *move_state_p, x, y;
{
	int x0, y0;

	if (s_p->winner)
		return 1;

	if (*move_state_p > 1)
	{
		move(s_p, move_data);
		*move_state_p = 0;

		XClearArea(display, win, 0, 0, 0, 0, True);
		return 1;
	}

	x -= BORDER;
	y -= BORDER;

	x0 = x / D_TILE - 3;
	y0 = y / D_TILE - 3;

	if (x < 0 || y < 0 || x0 < -3 - y0 || x0 < -3 + y0 ||
		x0 > 3 + y0 || x0 > 3 - y0)
		return 0;

	switch (*move_state_p)
	{
	case 0:
		if (board_state(s_p, x0, y0) * s_p->to_play <= 0)
			return 0;

		move_data->from.x = x0;
		move_data->from.y = y0;
		break;

	case 1:
		move_data->to.x = x0;
		move_data->to.y = y0;

		if (check_move(s_p, move_data) != MOVE_OK)
			return 0;

		break;
	}

	(*move_state_p)++;

	XClearArea(display, win, 0, 0, 0, 0, True);
	return 1;
}


static unsigned long make_pixel(win, color_name)
Window win;
char *color_name;
{
	Colormap cmap;
	XColor color, exact;

	cmap = DefaultColormap(display, screen);

	if (!XAllocNamedColor(display, cmap, color_name, &color, &exact))
	{
		fprintf(stderr, "can't allocate color %s\n", color_name);
		exit(1);
	}

	return color.pixel;
}


static GC make_gc(win, color_name)
Window win;
char *color_name;
{
	XGCValues gc_val;

	gc_val.foreground = make_pixel(win, color_name);

	return XCreateGC(display, win, GCForeground, &gc_val);
}


int main()
{
	Window win;
	GC white, black, red, cyan, purple, orange;
	XGCValues gc_val;

	struct state s_var, *s_p;
	struct move move_data;
	int move_state;


	display = XOpenDisplay("");
	screen = DefaultScreen(display);

	win = XCreateSimpleWindow(display, DefaultRootWindow(display),
		100, 100, WIN_SIZE + 2 * D_TILE, WIN_SIZE,
		CopyFromParent, CopyFromParent,
		WhitePixel(display, screen));

	XSelectInput(display, win, ExposureMask | ButtonPressMask);

	gc_val.foreground = WhitePixel(display, screen);
	white = XCreateGC(display, win, GCForeground, &gc_val);

	gc_val.foreground = BlackPixel(display, screen);
	black = XCreateGC(display, win, GCForeground, &gc_val);

	XSetWindowBackground(display, win, make_pixel(win, "#0d0"));

	colors.board_edge = black;
	colors.board_top = make_gc(win, "#fa0");
	colors.board_front = make_gc(win, "#fd8");
	colors.board_side = make_gc(win, "#fb4");

	colors.player1.top.edge = make_gc(win, "#555");
	colors.player1.top.face = make_gc(win, "#fff");
	colors.player1.side = make_gc(win, "#ddd");
	colors.player1.cross = black;

	colors.player2.top.edge = make_gc(win, "#bbb");
	colors.player2.top.face = make_gc(win, "#333");
	colors.player2.side = make_gc(win, "#000");
	colors.player2.cross = white;

	colors.pointer.edge = black;
	colors.pointer.face = make_gc(win, "#ff0");

	XMapWindow(display, win);

	s_p = &s_var;
	init_game(s_p);

	move_state = 0;

	for (;;)
	{
		XEvent ev;

		XNextEvent(display, &ev);

		if (ev.type == Expose)
			draw_game(win, &colors, s_p, &move_data, move_state);
		else if (ev.type == ButtonPress &&
			ev.xbutton.button == Button1)
		{
			if (!process_click(win, &colors, s_p,
				&move_data, &move_state,
				ev.xbutton.x, ev.xbutton.y))
				XBell(display, 0);
		}
		else if (ev.type == ButtonPress &&
			ev.xbutton.button == Button3 && move_state != 0)
		{
			move_state = 0;
			XClearArea(display, win, 0, 0, 0, 0, True);
		}
	}
}
