/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <X11/Xlib.h>

#include "focus.h"
#include "event.h"

#ifndef lint
static char sccsid[] = "@(#)focus.c	1.6 2/8/99";
#endif


/* shared */
static Display *display;

static void *focus_handle;
static int lost_focus;


/*ARGSUSED*/
static void e_focus(void *handle, XEvent *evP)
{
	/* any focus change means the focus is still ok, unless it's
	   the change to None */
	lost_focus = evP->xfocus.detail == NotifyDetailNone &&
		evP->xfocus.type == FocusIn;
}


/*ARGSUSED*/
static void e_button(void *handle, XEvent *evP)
{
	if (evP->xbutton.subwindow == None)
		XSetInputFocus(display, PointerRoot,
			RevertToPointerRoot, CurrentTime);
}


/* ----- */


int focus_has_work(void)
{
	return lost_focus;
}


void focus_do_workG(void)
{
	if (lost_focus)
	{
		XSetInputFocus(display, PointerRoot,
			RevertToPointerRoot, CurrentTime);
		lost_focus = 0;
	}
}


void focus_initG(Display *set_display, Window root_w)
{
	Window focus_w;
	int revert;

	display = set_display;

	if ((focus_handle = malloc(1)) == NULL)
		exit(100);

	select_eventsG(focus_handle, root_w,
		FocusChangeMask | ButtonPressMask);

	register_event_handler(focus_handle, root_w, FocusIn, e_focus);
	register_event_handler(focus_handle, root_w, FocusOut, e_focus);
	register_event_handler(focus_handle, root_w, ButtonPress, e_button);

	XGetInputFocus(display, &focus_w, &revert);
	lost_focus = focus_w == None;
}
