/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xmu/WinUtil.h>

#include "get_clients.h"

#ifndef lint
static char sccsid[] = "@(#)get_clients.c	1.4 2/8/99";
#endif


static cl_stateT *list;
static int list_n;


static int add_entry(Window w, int state)
{
	int i;

	for (i = 0; i < list_n; i++)
		if (list[i].w == w)
		{
			if (state != WithdrawnState)
				list[i].state = state;
			return i;
		}

	list_n++;
	if ((list = realloc(list, list_n * sizeof *list)) == NULL)
		exit(100);

	list[i].w = w;
	list[i].leader = w;
	list[i].state = state;
	return i;
}


static void move_behind(int *i1P, int *i2P)
{
	cl_stateT tmp;
	int i1, i2;

	i1 = *i1P;
	i2 = *i2P;

	if (i1 <= i2)
		return; /* already sorted */

	memcpy(&tmp, &list[i2], sizeof tmp);
	memmove(&list[i2], &list[i2 + 1], (i1 - i2) * sizeof *list);
	memcpy(&list[i1], &tmp, sizeof *list);

	*i1P = i1 - 1;
	*i2P = i1;
}


/* invariant: the leader entry is always the first of a group */

static void add_link(Window sup, Window inf)
{
	Window leader, old_leader;
	int sup_i, inf_i;
	int i;

	if (sup == inf)
		return;

	sup_i = add_entry(sup, WithdrawnState);
	inf_i = add_entry(inf, WithdrawnState);

	leader = list[sup_i].leader;
	old_leader = list[inf_i].leader;
	list[inf_i].leader = leader;

	move_behind(&sup_i, &inf_i);

	if (leader == old_leader)
		return;

	for (i = 0; i < list_n;)
		if (list[i].leader == old_leader)
		{
			list[i].leader = leader;
			if (i < inf_i)
			{
				int j;

				j = i;
				move_behind(&inf_i, &j);
				inf_i = j;
			}
		}
		else
			i++;
}


static void drop_entry(int k)
{
	if (list[k].w == list[k].leader)
	{
		Window leader, old_leader;
		int i;

		old_leader = list[k].leader;
		for (i = k + 1; i < list_n &&
			list[i].leader != old_leader; i++);

		if (i < list_n)
			for (leader = list[i].w; i < list_n; i++)
				if (list[i].leader == old_leader)
					list[i].leader = leader;
	}

	list_n--;
	if (list_n > k)
		memmove(&list[k], &list[k + 1], (list_n - k) * sizeof *list);
}


static Window get_window_prop(Display *display, Window w, Atom prop)
{
	Atom type;
	int format;
	unsigned long n_items, bytes_after;
	unsigned char *data;
	Window result;

	if (XGetWindowProperty(display, w, prop, 0, 1, False, XA_WINDOW,
		&type, &format, &n_items, &bytes_after, &data) != Success)
		return None;

	if (type != XA_WINDOW || format != 32 || n_items != 1)
	{
		XFree(data);
		return None;
	}

	result = (Window)*(long *)data;
	XFree(data);

	return result;
}


cl_stateT *get_clients(Display *display, int *nP)
{
	unsigned n;
	Atom wmstate_atom, client_leader_atom;
	Window dummy_w, *children;
	int i;

	if (!XQueryTree(display, DefaultRootWindow(display), &dummy_w,
		&dummy_w, &children, &n))
		return NULL;

	list_n = 0;
	list = malloc(sizeof *list); /* allocate dummy */
	if (list == NULL)
		exit(100);

	if (n == 0)
	{
		*nP = list_n;
		return list;
	}

	wmstate_atom = XInternAtom(display, "WM_STATE", False);
	client_leader_atom = XInternAtom(display, "WM_CLIENT_LEADER", False);

	for (i = 0; i < n; i++)
	{
		Window w, sup;
		Atom type;
		int format;
		unsigned long n_items, bytes_after;
		unsigned char *data;
		long state;
		XWMHints *hints;

		w = XmuClientWindow(display, children[i]);

		if (XGetWindowProperty(display, w, wmstate_atom,
			0 /* offset */, 1 /* length */, False /* delete */,
			wmstate_atom, &type, &format, &n_items, &bytes_after,
			&data) != Success)
			continue;
			
		if (type != wmstate_atom || format != 32 || n_items != 1)
		{
			XFree(data);
			continue;
		}

		state = *(long *)data;
		XFree(data);

		if (state != NormalState && state != IconicState)
			continue;

		add_entry(w, state);

		if ((hints = XGetWMHints(display, w)) != NULL)
		{
			if (hints->flags & WindowGroupHint)
				add_link(hints->window_group, w);
			XFree(hints);
		}

		if ((sup = get_window_prop(display, w,
			XA_WM_TRANSIENT_FOR)) != None)
			add_link(sup, w);

		if ((sup = get_window_prop(display, w,
			client_leader_atom)) != None)
			add_link(sup, w);
	}

	for (i = 0; i < list_n;)
		if (list[i].state == WithdrawnState)
			drop_entry(i);
		else
			i++;

	*nP = list_n;
	return list;
}
