/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xmu/WinUtil.h>

#include "query_pointer.h"

#ifndef lint
static char sccsid[] = "@(#)lockcmap.c	1.6 2/8/99";
#endif


int main(int argc, char **argv)
{
	Display *display;
	Window root_w, target_w;
	XEvent e;
	int unlock;

	unlock = argc > 1 && !strcmp(argv[1], "-u");
	if (argc != 1 + unlock)
	{
		fprintf(stderr, "usage: [-u] %s\n", argv[0]);
		exit(10);
	}

	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		fprintf(stderr, "%s: can't open display %s\n",
			argv[0], XDisplayName(NULL));
		exit(1);
	}

	root_w = DefaultRootWindow(display);

	if (unlock)
		target_w = None;
	else
	{
		target_w = query_pointer(display, NULL, NULL);

		if (target_w == None)
			target_w = root_w;
	}

	memset(&e, 0, sizeof e);
	e.xclient.type = ClientMessage;
	e.xclient.window = root_w;
	e.xclient.message_type = XInternAtom(display,
		"_WWM_COLORMAP_PRIORITY_WINDOW", False /* only if exists */);
	e.xclient.format = 32;
	e.xclient.data.l[0] = target_w;
	e.xclient.data.l[1] = e.xclient.data.l[2] = 0;
	e.xclient.data.l[3] = e.xclient.data.l[4] = 0;

	if (!XSendEvent(display, root_w, False /* propagate */,
		SubstructureRedirectMask | SubstructureNotifyMask, &e))
		exit(1);

	XCloseDisplay(display);
	return 0;
}
