/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <X11/X.h>
#include <X11/Xlib.h>

#ifndef lint
static char sccsid[] = "@(#)makesticky.c	1.4 2/8/99";
#endif


int main(int argc, char **argv)
{
	unsigned long id;
	char *endP;
	Display *disp;
	Window w;
	Atom is_sticky, no_type;

	if (argc != 2 || (id = strtoul(argv[1], &endP, 0)) == 0 || *endP)
	{
		fprintf(stderr, "usage: %s XID\n", argv[0]);
		exit(10);
	}

	disp = XOpenDisplay("");
	if (disp == NULL)
	{
		fprintf(stderr, "can't open display\n");
		exit(1);
	}

	w = (Window)id;

	is_sticky = XInternAtom(disp, "_WWM_IS_STICKY", False);
	no_type = XInternAtom(disp, "NULL", False);

	XChangeProperty(disp, w, is_sticky, no_type, 8, PropModeReplace,
		(unsigned char *)"", 0);

	XCloseDisplay(disp);
	return 0;
}
