/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <X11/Xlib.h>

#include "query_pointer.h"

#ifndef lint
static char sccsid[] = "@(#)query_pointer.c	1.4 2/8/99";
#endif


Window query_pointer(Display *display, int *xP, int *yP)
{
	Window w, dummy_w;
	char *w_env, *x_env, *y_env;
	int x, y, dummy_x, dummy_y;
	unsigned dummy_mask;

	w_env = x_env = y_env = NULL;

	if ((w_env = getenv("KEYTOOLS_WINDOW")) != NULL &&
		((x_env = getenv("KEYTOOLS_X")) != NULL || xP == NULL) &&
		((y_env = getenv("KEYTOOLS_Y")) != NULL || yP == NULL))
	{
		if (xP != NULL)
			*xP = strtol(x_env, NULL, 0);
		if (yP != NULL)
			*yP = strtol(y_env, NULL, 0);

		return strtoul(w_env, NULL, 0);
	}

	if (!XQueryPointer(display, DefaultRootWindow(display), &dummy_w, &w,
		&x, &y, &dummy_x, &dummy_y, &dummy_mask))
	{
		XBell(display, 0);
		XCloseDisplay(display);
		exit(1);
	}

	if (w_env != NULL)
		w = strtoul(w_env, NULL, 0);

	if (x_env != NULL)
		x = strtol(x_env, NULL, 0);
	if (y_env != NULL)
		y = strtol(y_env, NULL, 0);

	if (xP != NULL)
		*xP = x;
	if (yP != NULL)
		*yP = y;
	return w;
}
