/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Intrinsic.h>

#include "resource.h"

#ifndef lint
static char sccsid[] = "@(#)resource.c	1.7 2/8/99";
#endif


/* shared */
static Display *display;

static XrmDatabase db;
static XrmQuark qstring;


static int get_string(XrmValue *valP, char *name, char *class)
{
	XrmQuark n[100], c[100];
	XrmRepresentation type;

	XrmStringToNameList(name, n);
	XrmStringToClassList(class, c);

	return XrmQGetResource(db, n, c, &type, valP) && type == qstring;
}


/* ----- */


void resource_init(Display *set_display, int *argcP, char **argv)
{
	XtAppContext app_ctx;

	display = set_display;

	XtToolkitInitialize();
	app_ctx = XtCreateApplicationContext();

	XtDisplayInitialize(app_ctx, display, "wwm", "Wwm",
		NULL, 0, argcP, argv);

	db = XtDatabase(display);
	qstring = XrmStringToQuark("String");
}


char *resource_lookup_string(char *name, char *class, char *default_val)
{
	XrmValue val;

	if (!get_string(&val, name, class))
		return default_val;
	else
		return val.addr;
}


int resource_lookup_bool(char *name, char *class, int default_val)
{
	XrmValue val, bool_val;
	char bool;

	if (!get_string(&val, name, class))
		return default_val;

	bool_val.size = 1;
	bool_val.addr = (void *)&bool;
	bool = default_val;
	if (!XtCallConverter(display, XtCvtStringToBoolean, NULL, 0,
		&val, &bool_val, NULL))
		return default_val;
	else
		return bool;
}


int resource_lookup_dimension(char *name, char *class, int default_val)
{
	XrmValue val, dim_val;
	Dimension dim;

	if (!get_string(&val, name, class))
		return default_val;

	dim_val.size = sizeof dim;
	dim_val.addr = (void *)&dim;
	dim = default_val;
	if (!XtCallConverter(display, XtCvtStringToDimension, NULL, 0,
		&val, &dim_val, NULL))
		return default_val;
	else
		return dim;
}
