/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>

#include "get_clients.h"

#ifndef lint
static char sccsid[] = "@(#)xiconbox.c	1.7 2/8/99";
#endif


static Atom wm_delwin;

static Window *icon_w_list;
static char **icon_label_list;


static void deiconify(Display *display, Window w)
{
	XEvent e;

	memset(&e, 0, sizeof e);
	e.xclient.type = ClientMessage;
	e.xclient.window = w;
	e.xclient.message_type = XInternAtom(display, "_WWM_SET_STATE", False);
	e.xclient.format = 32;
	e.xclient.data.l[0] = NormalState;
	XSendEvent(display, DefaultRootWindow(display), False /* propagate */,
		SubstructureRedirectMask | SubstructureNotifyMask, &e);
}


/*ARGSUSED*/
static void die(Widget w, XtPointer closure, XtPointer call_data)
{
	XCloseDisplay(XtDisplay(w));
	exit(0);
}


/*ARGSUSED*/
static void quit(Widget w, XEvent *event, String *params, Cardinal *n)
{
	if (event->type == ClientMessage &&
		event->xclient.data.l[0] != wm_delwin)
		return;

	XCloseDisplay(XtDisplay(w));
	exit(0);
}


/*ARGSUSED*/
static void execute(Widget w, XEvent *event, String *params, Cardinal *n)
{
	XawListReturnStruct *s;

	if ((s = XawListShowCurrent(w)) != NULL && s->list_index >= 0)
	{
		deiconify(XtDisplay(w), icon_w_list[s->list_index]);

		XCloseDisplay(XtDisplay(w));
		exit(0);
	}
}


/*ARGSUSED*/
static void clear(Widget w, XEvent *event, String *params, Cardinal *n)
{
	XawListUnhighlight(w);
}


int main(int argc, char **argv)
{
	XtAppContext app_ctx;
	Widget top_w, form_w, quit_w;
	cl_stateT *clients;
	int i, j, n;
	static XtActionsRec actions[] =
	{
		{ "quit", quit },
		{ "unselect", clear },
		{ "deiconify", execute }
	};

	top_w = XtVaAppInitialize(&app_ctx, "XIconBox",
		NULL, 0, &argc, argv, NULL,
		NULL);

	if ((clients = get_clients(XtDisplay(top_w), &n)) == NULL)
		exit(1);

	if (n)
	{
		if ((icon_w_list = malloc(n * sizeof *icon_w_list)) == NULL ||
			(icon_label_list =
				malloc(n * sizeof *icon_label_list)) == NULL)
			exit(100);
	}

	for (i = j = 0; i < n; i++)
		if (clients[i].state == IconicState)
		{
			char *tmp;

			icon_w_list[j] = clients[i].w;
			if (XGetIconName(XtDisplay(top_w),
				icon_w_list[j], &tmp))
				icon_label_list[j] = tmp;
			else
				icon_label_list[j] = "?";
			j++;
		}

	n = j;
	if (n < 1)
	{
		XBell(XtDisplay(top_w), 0);
		XCloseDisplay(XtDisplay(top_w));
		exit(1);
	}

	form_w = XtVaCreateManagedWidget("form", formWidgetClass, top_w,
		NULL);

	quit_w = XtVaCreateManagedWidget("quit", commandWidgetClass, form_w,
		NULL);

	XtAddCallback(quit_w, XtNcallback, die, (XtPointer)NULL);

	XtVaCreateManagedWidget("list", listWidgetClass, form_w,
		XtNlist, icon_label_list,
		XtNnumberStrings, n,
		NULL);

	XtAddCallback(top_w, XtNdestroyCallback, die, (XtPointer)NULL);
	XtAppAddActions(app_ctx, actions, XtNumber(actions));
	XtOverrideTranslations(top_w,
		XtParseTranslationTable("<Message>WM_PROTOCOLS: quit()"));

	XtRealizeWidget(top_w);

	wm_delwin = XInternAtom(XtDisplay(top_w), "WM_DELETE_WINDOW", False);
	XSetWMProtocols(XtDisplay(top_w), XtWindow(top_w), &wm_delwin, 1);

	XtAppMainLoop(app_ctx);

	return 0;
}
