/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xmu/WinUtil.h>

#include "query_pointer.h"
#include "get_clients.h"

#ifndef lint
static char sccsid[] = "@(#)xiconify.c	1.7 2/8/99";
#endif


static Display *display;


static void iconify(Window w, int undo)
{
	XEvent e;
	static int first = 1;
	static Atom wwm_set_state;

	if (first)
	{
		first = 0;
		wwm_set_state = XInternAtom(display, "_WWM_SET_STATE", False);
	}

	memset(&e, 0, sizeof e);
	e.xclient.type = ClientMessage;
	e.xclient.window = w;
	e.xclient.message_type = wwm_set_state;
	e.xclient.format = 32;
	e.xclient.data.l[0] = undo ? NormalState : IconicState;
	XSendEvent(display, DefaultRootWindow(display), False /* propagate */,
		SubstructureRedirectMask | SubstructureNotifyMask, &e);
}


static void iconify_client(cl_stateT *cP, int undo)
{
	if (undo && cP->state == IconicState ||
		!undo && cP->state == NormalState)
		iconify(cP->w, undo);
}


int main(int argc, char **argv)
{
	int skip;
	unsigned long id;
	char *endP;
	Window w;
	int undo, group, all;

	skip = 1;
	undo = group = all = 0;

	while (argc > skip)
		if (!undo && !strcmp(argv[skip], "-u"))
		{
			undo = 1;
			skip++;
		}
		else if (!group && !strcmp(argv[skip], "-g"))
		{
			group = 1;
			skip++;
		}
		else if (!all && !strcmp(argv[skip], "-all"))
		{
			all = 1;
			skip++;
		}
		else
			break;

	if (!all && argc > skip &&
		(id = strtoul(argv[skip], &endP, 0)) != 0 && *endP == 0)
		skip++;
	else
		id = 0;

	if (argc != skip || (group && all))
	{
		fprintf(stderr, "usage: %s [-u] [-g] [-all | XID]\n", argv[0]);
		exit(10);
	}

	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		fprintf(stderr, "%s: can't open display %s\n",
			argv[0], XDisplayName(NULL));
		exit(1);
	}

	if (group)
	{
		cl_stateT *clients;
		int i, n;

		if (id)
			w = (Window)id;
		else if ((w = query_pointer(display, NULL, NULL)) == None)
		{
			XBell(display, 0);
			XCloseDisplay(display);
			exit(1);
		}
		else
			w = XmuClientWindow(display, w);

		if ((clients = get_clients(display, &n)) == NULL)
		{
			XBell(display, 0);
			XCloseDisplay(display);
			exit(1);
		}

		for (i = 0; i < n && clients[i].w != w; i++);
		if (i >= n)
		{
			XBell(display, 0);
			XCloseDisplay(display);
			exit(1);
		}

		w = clients[i].leader;

		for (i = 0; i < n; i++)
			if (clients[i].leader == w)
				iconify_client(&clients[i], undo);

		free(clients);
	}
	else if (id)
		iconify((Window)id, undo);
	else if (all)
	{
		cl_stateT *clients;
		int i, n;

		if ((clients = get_clients(display, &n)) == NULL)
		{
			XBell(display, 0);
			XCloseDisplay(display);
			exit(1);
		}

		for (i = 0; i < n; i++)
			iconify_client(&clients[i], undo);

		free(clients);
	}
	else if ((w = query_pointer(display, NULL, NULL)) == None)
	{
		XBell(display, 0);
		XCloseDisplay(display);
		exit(1);
	}
	else
		iconify(XmuClientWindow(display, w), undo);

	XCloseDisplay(display);
	return 0;
}
