/*
**	Copyright (c) 1998, 1999 by Joerg Czeranski
**	All rights reserved.
**
**	Redistribution and use in source and binary forms, with or without
**	modification, are permitted provided that the following conditions are
**	met:
**
**	1. Redistributions of source code must retain the above copyright
**	   notice, this list of conditions and the following disclaimer.
**	2. Redistributions in binary form must reproduce the above copyright
**	   notice, this list of conditions and the following disclaimer in the
**	   documentation and/or other materials provided with the distribution.
**	3. The name of the author may not be used to endorse or promote
**	   products derived from this software without specific prior written
**	   permission.
**
**	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
**	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**	DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
**	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
**	SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
**	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
**	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
**	IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
**	POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "get_clients.h"

#ifndef lint
static char sccsid[] = "@(#)xlsicons.c	1.9 2/8/99";
#endif


static char *dup_string(char *str)
{
	char *s;
	size_t i, n;

	n = strlen(str);
	if (n > 32)
		n = 32;

	if ((s = malloc(n + 1)) == NULL)
		exit(100);

	memcpy(s, str, n);
	s[n] = 0;

	for (i = 0; i < n; i++)
	{
		unsigned char c;

		c = s[i];
		if (c < ' ' || c > '~' && c < 0xa0)
			s[i] = '?';
	}

	return s;
}


int main(int argc, char **argv)
{
	Display *display;
	cl_stateT *clients;
	int i, n, leader_missing;

	if (argc != 1)
	{
		fprintf(stderr, "usage: %s\n", argv[0]);
		exit(10);
	}

	display = XOpenDisplay(NULL);
	if (display == NULL)
	{
		fprintf(stderr, "%s: can't open display %s\n",
			argv[0], XDisplayName(NULL));
		exit(1);
	}

	if ((clients = get_clients(display, &n)) == NULL)
		exit(1);

	leader_missing = 1;
	for (i = 0; i < n; i++)
	{
		Window w;
		XTextProperty prop;
		char *tmp, *icon_name, *machine_name;
		int subst_name;

		if (clients[i].w == clients[i].leader)
			leader_missing = 1;

		if (clients[i].state != IconicState)
			continue;

		w = clients[i].w;
		subst_name = 0;
		if (XGetIconName(display, w, &tmp))
		{
			icon_name = dup_string(tmp);
			XFree(tmp);
		}
		else if (XFetchName(display, w, &tmp))
		{
			icon_name = dup_string(tmp);
			XFree(tmp);
			subst_name = 1;
		}
		else
			icon_name = dup_string("?");

		machine_name = NULL;
		if (XGetWMClientMachine(display, w, &prop))
		{
			char **list;
			int k;

			if (XTextPropertyToStringList(&prop, &list, &k))
			{
				if (k > 0 && list[0][0] != 0)
					machine_name = dup_string(list[0]);

				XFreeStringList(list);
			}

			XFree(prop.value);
		}

		if (clients[i].w == clients[i].leader)
			leader_missing = 0;
		else if (leader_missing)
		{
			printf("(%#10lx)\n    ",
				(unsigned long)clients[i].leader);
			leader_missing = 0;
		}
		else
			printf("    ");

		printf("%#10lx: ", (unsigned long)w);

		if (subst_name)
			printf("(%s)", icon_name);
		else
			printf("%s", icon_name);

		if (machine_name != NULL)
			printf(" [%s]", machine_name);

		printf("\n");

		free(icon_name);
		if (machine_name != NULL)
			free(machine_name);
	}

	free(clients);
	XCloseDisplay(display);
	return 0;
}
